/**
* \file: gst_viv_buffer.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* EGL Buffer for Gstreamer framework.
* This buffer is used to pass the rendered scene from egl to the
* gstreamer
*
*
* \component: gst_viv_demo
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2012 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
***********************************************************************/

#ifndef _GST_EGL_BUFFER_H_
#define _GST_EGL_BUFFER_H_

#include <gst/gst.h>
#include <GLES2/gl2.h>
#include "EGL/egl.h"
#include "EGL/eglvivante.h"

G_BEGIN_DECLS


GType gst_egl_buffer_get_type (void);


typedef struct _GstEglBuffer GstEglBuffer;
typedef struct _GstEglBufferClass GstEglBufferClass;

struct _GstEglBuffer
{
  GstBuffer buffer;

  GstElement *parent;
  gboolean (*finalize)(GstEglBuffer *buffer, GstElement *parent);

  EGLNativePixmapType native_pixmap;
  EGLSurface window_surface;
};


struct _GstEglBufferClass
{
  GstBufferClass klass;
};



#define GST_TYPE_EGL_BUFFER (gst_egl_buffer_get_type())

#define GST_IS_EGL_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_EGL_BUFFER))
#define GST_EGL_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_EGL_BUFFER, GstEglBuffer))
#define GST_EGL_BUFFER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GST_TYPE_EGL_BUFFER, GstEglBufferClass))


G_END_DECLS

#endif /* _GST_EGL_BUFFER_H_ */
